/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.bgp.eui;

import ibm.nways.bgp.model.PeerModel;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.NavFieldOverride;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.eui.EuiGrid;
import ibm.nways.jdm.eui.EuiGridEvent;
import ibm.nways.jdm.eui.EuiGridListener;
import ibm.nways.jdm.eui.HexInput;
import ibm.nways.jdm.eui.HexInputRO;
import ibm.nways.jdm.eui.IPInput;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.LongNumericInput;
import ibm.nways.jdm.eui.NumericInput;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.SingleChoiceInput;
import ibm.nways.jdm.eui.SingleChoiceInputRO;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.jdm.eui.Table;
import ibm.nways.jdm.eui.TableColumn;
import ibm.nways.jdm.eui.TableColumns;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.TableStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class BgpPeerPanel
extends DestinationPropBook {
    protected static ResourceBundle enumStrings = null;
    protected static ResourceBundle myResources = null;
    private static String title = "Peer";
    protected boolean containsWritableField = false;
    protected boolean containsCreatableField = false;
    protected GenModel Peer_model;
    protected selectionListSection selectionListPropertySection;
    protected bgpPeerDetailSection bgpPeerDetailPropertySection;
    protected ModelInfo BgpPeerTableInfo;
    protected ModelInfo PanelInfo;
    protected int BgpPeerTableIndex;
    protected BgpPeerTable BgpPeerTableData;
    protected TableColumns BgpPeerTableColumns;
    protected TableStatus BgpPeerTableStatus;
    protected static TableColumn[] BgpPeerTableCols = new TableColumn[]{new TableColumn("Index.BgpPeerRemoteAddr", "Remote Address", 4, true), new TableColumn("Panel.BgpPeerIdentifier", "Identifier", 4, false), new TableColumn("Panel.BgpPeerState", "State", 16, false)};
    protected boolean errorsFound = false;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.bgp.eui.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.bgp.eui.BgpPeerPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel BgpPeer");
        }
    }

    public static String getTitle() {
        BgpPeerPanel.loadStatics();
        if (myResources != null) {
            title = BgpPeerPanel.getNLSString("BgpPeerPanelTitle");
        }
        return title;
    }

    private static ResourceBundle getEnumStrings() {
        if (enumStrings == null) {
            BgpPeerPanel.loadStatics();
        }
        return enumStrings;
    }

    public BgpPeerPanel() {
        BgpPeerPanel.loadStatics();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public String getDestinationTitle() {
        return BgpPeerPanel.getTitle();
    }

    protected void getModels() {
        this.Peer_model = (GenModel)this.getModel();
    }

    public void addSections() {
        this.getModels();
        this.createTables();
        this.addselectionListSection();
        this.addbgpPeerDetailSection();
        if (this.containsCreatableField) {
            this.addCreateButton();
        }
        if (this.containsWritableField) {
            this.addApplyButton();
        }
        this.addRefreshButton();
        this.addHelpButton();
        this.reset();
    }

    protected void addselectionListSection() {
        this.selectionListPropertySection = new selectionListSection();
        this.selectionListPropertySection.layoutSection();
        this.addSection(BgpPeerPanel.getNLSString("selectionListSectionTitle"), this.selectionListPropertySection);
    }

    protected void addbgpPeerDetailSection() {
        this.bgpPeerDetailPropertySection = new bgpPeerDetailSection();
        this.bgpPeerDetailPropertySection.layoutSection();
        this.addSection(BgpPeerPanel.getNLSString("bgpPeerDetailSectionTitle"), this.bgpPeerDetailPropertySection);
    }

    protected void panelRowChange() {
        if (this.selectionListPropertySection != null) {
            this.selectionListPropertySection.rowChange();
        }
        if (this.bgpPeerDetailPropertySection != null) {
            this.bgpPeerDetailPropertySection.rowChange();
        }
    }

    public void filterPanelInfos(Vector vector) {
    }

    public int getInitialBgpPeerTableRow() {
        return 0;
    }

    public ModelInfo initialBgpPeerTableRow() {
        ModelInfo modelInfo = null;
        if (this.getNavContext() instanceof NavigationContext) {
            modelInfo = NavInitialRow.getInitialRow(this.getNavContext(), true);
        }
        return modelInfo;
    }

    protected void displayMsg(String string) {
        if (this.getBrowser() != null) {
            this.getBrowser().displayMsg(string);
        }
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    protected String getOverride(String string, String string2) {
        String string3 = null;
        try {
            string3 = NavFieldOverride.getFieldOverride(this.getNavContext(), string);
        }
        catch (ClassCastException classCastException) {
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NullPointerException nullPointerException) {}
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void reset() {
        this.displayMsg(BgpPeerPanel.getNLSString("startResetMsg"));
        this.BgpPeerTableData.invalidate();
        this.errorsFound = false;
        super.reset();
        if (!this.errorsFound) {
            this.displayMsg(BgpPeerPanel.getNLSString("endResetMsg"));
            return;
        }
        this.displayMsg(String.valueOf(BgpPeerPanel.getNLSString("endResetMsg")) + " " + BgpPeerPanel.getNLSString("noteErrorsMsg"));
    }

    public void apply() {
        this.PanelInfo = new ModelInfo();
        this.PanelInfo.add("Index.BgpPeerRemoteAddr", (Serializable)this.BgpPeerTableData.getValueAt("Index.BgpPeerRemoteAddr", this.BgpPeerTableIndex));
        this.errorsFound = false;
        this.displayMsg(BgpPeerPanel.getNLSString("startApplyMsg"));
        super.apply();
        if (!this.errorsFound) {
            this.BgpPeerTableInfo = (ModelInfo)this.BgpPeerTableData.elementAt(this.BgpPeerTableIndex);
            this.BgpPeerTableInfo = this.BgpPeerTableData.setRow();
            this.BgpPeerTableData.setElementAt(this.BgpPeerTableInfo, this.BgpPeerTableIndex);
            super.reset();
            if (!this.errorsFound) {
                this.displayMsg(BgpPeerPanel.getNLSString("endApplyMsg"));
                return;
            }
            this.displayMsg(String.valueOf(BgpPeerPanel.getNLSString("endApplyMsg")) + " " + BgpPeerPanel.getNLSString("noteErrorsMsg"));
            return;
        }
        this.displayMsg(BgpPeerPanel.getNLSString("abortApplyMsg"));
    }

    public void createTables() {
        this.BgpPeerTableData = new BgpPeerTable();
        this.BgpPeerTableIndex = 0;
        this.BgpPeerTableColumns = new TableColumns(BgpPeerTableCols);
        if (this.Peer_model instanceof RemoteModelWithStatus) {
            try {
                this.BgpPeerTableStatus = (TableStatus)this.Peer_model.getStatus();
                return;
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
                return;
            }
        }
    }

    public class selectionListSection
    extends PropertySection
    implements EuiGridListener {
        ModelInfo chunk;
        Component BgpPeerTableField;
        Label BgpPeerTableFieldLabel;
        boolean BgpPeerTableFieldWritable = false;

        public selectionListSection() {
            BgpPeerPanel.this = BgpPeerPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createBgpPeerTableField() {
            EuiGrid euiGrid = new EuiGrid(BgpPeerPanel.this.BgpPeerTableData, BgpPeerPanel.this.BgpPeerTableColumns, true);
            euiGrid.addRows(5);
            euiGrid.addEuiGridListener(this);
            euiGrid.setInitialRow(BgpPeerPanel.this.initialBgpPeerTableRow());
            this.addTable(BgpPeerPanel.getNLSString("BgpPeerTableLabel"), euiGrid);
            return euiGrid;
        }

        public void layoutSection() {
            this.BgpPeerTableField = this.createBgpPeerTableField();
        }

        public void apply() {
            if (!this.validateSection()) {
                BgpPeerPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("accessDataMsg"));
            BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("startTableGetMsg"));
            ((EuiGrid)this.BgpPeerTableField).refresh();
            BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("endTableGetMsg"));
            BgpPeerPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.doLayout();
        }

        public boolean validateSection() {
            return true;
        }

        public void onEuiGridEvent(EuiGridEvent euiGridEvent) {
            System.out.println("Event received in section");
            if (euiGridEvent.getType() == 2001) {
                try {
                    if (euiGridEvent.getSource() == this.BgpPeerTableField) {
                        BgpPeerPanel.this.BgpPeerTableIndex = euiGridEvent.getRow();
                    }
                    BgpPeerPanel.this.BgpPeerTableIndex = euiGridEvent.getRow();
                    ((EuiGrid)this.BgpPeerTableField).deselectAllRows();
                    BgpPeerPanel.this.panelRowChange();
                    return;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    EuiGrid euiGrid = (EuiGrid)euiGridEvent.getSource();
                    euiGrid.deleteAllRows();
                    if (euiGridEvent.getSource() == this.BgpPeerTableField) {
                        BgpPeerPanel.this.BgpPeerTableIndex = 0;
                    }
                    BgpPeerPanel.this.selectionListPropertySection.reset();
                    BgpPeerPanel.this.bgpPeerDetailPropertySection.reset();
                    return;
                }
            }
        }
    }

    public class bgpPeerDetailSection
    extends PropertySection {
        ModelInfo chunk;
        Component bgpPeerIdentifierField;
        Component bgpPeerStateField;
        Component bgpPeerAdminStatusField;
        Component bgpPeerNegotiatedVersionField;
        Component bgpPeerLocalAddrField;
        Component bgpPeerLocalPortField;
        Component bgpPeerRemoteAddrField;
        Component bgpPeerRemotePortField;
        Component bgpPeerRemoteAsField;
        Component bgpPeerLastErrorField;
        Component bgpPeerFsmEstablishedTimeField;
        Component bgpPeerConnectRetryIntervalField;
        Component bgpPeerHoldTimeField;
        Component bgpPeerKeepAliveField;
        Component bgpPeerHoldTimeConfiguredField;
        Component bgpPeerKeepAliveConfiguredField;
        Component bgpPeerMinASOriginationIntervalField;
        Component bgpPeerMinRouteAdvertisementIntervalField;
        Component bgpPeerInUpdateElapsedTimeField;
        Label bgpPeerIdentifierFieldLabel;
        Label bgpPeerStateFieldLabel;
        Label bgpPeerAdminStatusFieldLabel;
        Label bgpPeerNegotiatedVersionFieldLabel;
        Label bgpPeerLocalAddrFieldLabel;
        Label bgpPeerLocalPortFieldLabel;
        Label bgpPeerRemoteAddrFieldLabel;
        Label bgpPeerRemotePortFieldLabel;
        Label bgpPeerRemoteAsFieldLabel;
        Label bgpPeerLastErrorFieldLabel;
        Label bgpPeerFsmEstablishedTimeFieldLabel;
        Label bgpPeerConnectRetryIntervalFieldLabel;
        Label bgpPeerHoldTimeFieldLabel;
        Label bgpPeerKeepAliveFieldLabel;
        Label bgpPeerHoldTimeConfiguredFieldLabel;
        Label bgpPeerKeepAliveConfiguredFieldLabel;
        Label bgpPeerMinASOriginationIntervalFieldLabel;
        Label bgpPeerMinRouteAdvertisementIntervalFieldLabel;
        Label bgpPeerInUpdateElapsedTimeFieldLabel;
        boolean bgpPeerIdentifierFieldWritable = false;
        boolean bgpPeerStateFieldWritable = false;
        boolean bgpPeerAdminStatusFieldWritable = false;
        boolean bgpPeerNegotiatedVersionFieldWritable = false;
        boolean bgpPeerLocalAddrFieldWritable = false;
        boolean bgpPeerLocalPortFieldWritable = false;
        boolean bgpPeerRemoteAddrFieldWritable = false;
        boolean bgpPeerRemotePortFieldWritable = false;
        boolean bgpPeerRemoteAsFieldWritable = false;
        boolean bgpPeerLastErrorFieldWritable = false;
        boolean bgpPeerFsmEstablishedTimeFieldWritable = false;
        boolean bgpPeerConnectRetryIntervalFieldWritable = false;
        boolean bgpPeerHoldTimeFieldWritable = false;
        boolean bgpPeerKeepAliveFieldWritable = false;
        boolean bgpPeerHoldTimeConfiguredFieldWritable = false;
        boolean bgpPeerKeepAliveConfiguredFieldWritable = false;
        boolean bgpPeerMinASOriginationIntervalFieldWritable = false;
        boolean bgpPeerMinRouteAdvertisementIntervalFieldWritable = false;
        boolean bgpPeerInUpdateElapsedTimeFieldWritable = false;

        public bgpPeerDetailSection() {
            BgpPeerPanel.this = BgpPeerPanel.this;
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
        }

        protected Component createbgpPeerIdentifierField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerIdentifier.access", "read-only");
            this.bgpPeerIdentifierFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerIdentifierFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerIdentifierLabel"), 2);
            if (this.bgpPeerIdentifierFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(this.bgpPeerIdentifierFieldLabel, (Component)iPInput);
                BgpPeerPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerIdentifierFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerIdentifierField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerIdentifierField);
            this.validatebgpPeerIdentifierField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerIdentifierField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerIdentifierField);
                jDMInput.setValue(object);
                this.validatebgpPeerIdentifierField();
            }
        }

        protected boolean validatebgpPeerIdentifierField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerIdentifierField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerIdentifierFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerIdentifierFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerStateField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerState.access", "read-only");
            this.bgpPeerStateFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerStateFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerStateLabel"), 2);
            if (this.bgpPeerStateFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(PeerModel.Panel.BgpPeerStateEnum.symbolicValues, PeerModel.Panel.BgpPeerStateEnum.numericValues, BgpPeerPanel.getEnumStrings());
                this.addRow(this.bgpPeerStateFieldLabel, (Component)singleChoiceInput);
                BgpPeerPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(PeerModel.Panel.BgpPeerStateEnum.symbolicValues, PeerModel.Panel.BgpPeerStateEnum.numericValues, BgpPeerPanel.getEnumStrings());
            this.addRow(this.bgpPeerStateFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getbgpPeerStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerStateField);
            this.validatebgpPeerStateField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerStateField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerStateField);
                jDMInput.setValue(object);
                this.validatebgpPeerStateField();
            }
        }

        protected boolean validatebgpPeerStateField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerStateField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerStateFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerStateFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerAdminStatusField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerAdminStatus.access", "read-write");
            this.bgpPeerAdminStatusFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerAdminStatusFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerAdminStatusLabel"), 2);
            if (this.bgpPeerAdminStatusFieldWritable) {
                SingleChoiceInput singleChoiceInput = new SingleChoiceInput(PeerModel.Panel.BgpPeerAdminStatusEnum.symbolicValues, PeerModel.Panel.BgpPeerAdminStatusEnum.numericValues, BgpPeerPanel.getEnumStrings());
                this.addRow(this.bgpPeerAdminStatusFieldLabel, (Component)singleChoiceInput);
                BgpPeerPanel.this.containsWritableField = true;
                return singleChoiceInput;
            }
            SingleChoiceInputRO singleChoiceInputRO = new SingleChoiceInputRO(PeerModel.Panel.BgpPeerAdminStatusEnum.symbolicValues, PeerModel.Panel.BgpPeerAdminStatusEnum.numericValues, BgpPeerPanel.getEnumStrings());
            this.addRow(this.bgpPeerAdminStatusFieldLabel, (Component)singleChoiceInputRO);
            return singleChoiceInputRO;
        }

        protected Serializable getbgpPeerAdminStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerAdminStatusField);
            this.validatebgpPeerAdminStatusField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerAdminStatusField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerAdminStatusField);
                jDMInput.setValue(object);
                this.validatebgpPeerAdminStatusField();
            }
        }

        protected boolean validatebgpPeerAdminStatusField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerAdminStatusField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerAdminStatusFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerAdminStatusFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerNegotiatedVersionField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerNegotiatedVersion.access", "read-only");
            this.bgpPeerNegotiatedVersionFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerNegotiatedVersionFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerNegotiatedVersionLabel"), 2);
            if (this.bgpPeerNegotiatedVersionFieldWritable) {
                NumericInput numericInput = new NumericInput();
                this.addRow(this.bgpPeerNegotiatedVersionFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerNegotiatedVersionFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerNegotiatedVersionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerNegotiatedVersionField);
            this.validatebgpPeerNegotiatedVersionField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerNegotiatedVersionField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerNegotiatedVersionField);
                jDMInput.setValue(object);
                this.validatebgpPeerNegotiatedVersionField();
            }
        }

        protected boolean validatebgpPeerNegotiatedVersionField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerNegotiatedVersionField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerNegotiatedVersionFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerNegotiatedVersionFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerLocalAddrField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerLocalAddr.access", "read-only");
            this.bgpPeerLocalAddrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerLocalAddrFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerLocalAddrLabel"), 2);
            if (this.bgpPeerLocalAddrFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(this.bgpPeerLocalAddrFieldLabel, (Component)iPInput);
                BgpPeerPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerLocalAddrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerLocalAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLocalAddrField);
            this.validatebgpPeerLocalAddrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerLocalAddrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLocalAddrField);
                jDMInput.setValue(object);
                this.validatebgpPeerLocalAddrField();
            }
        }

        protected boolean validatebgpPeerLocalAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLocalAddrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerLocalAddrFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerLocalAddrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerLocalPortField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerLocalPort.access", "read-only");
            this.bgpPeerLocalPortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerLocalPortFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerLocalPortLabel"), 2);
            if (this.bgpPeerLocalPortFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.bgpPeerLocalPortFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerLocalPortFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerLocalPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLocalPortField);
            this.validatebgpPeerLocalPortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerLocalPortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLocalPortField);
                jDMInput.setValue(object);
                this.validatebgpPeerLocalPortField();
            }
        }

        protected boolean validatebgpPeerLocalPortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLocalPortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerLocalPortFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerLocalPortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerRemoteAddrField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerRemoteAddr.access", "read-only");
            this.bgpPeerRemoteAddrFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerRemoteAddrFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerRemoteAddrLabel"), 2);
            if (this.bgpPeerRemoteAddrFieldWritable) {
                IPInput iPInput = new IPInput();
                this.addRow(this.bgpPeerRemoteAddrFieldLabel, (Component)iPInput);
                BgpPeerPanel.this.containsWritableField = true;
                return iPInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerRemoteAddrFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerRemoteAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemoteAddrField);
            this.validatebgpPeerRemoteAddrField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerRemoteAddrField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemoteAddrField);
                jDMInput.setValue(object);
                this.validatebgpPeerRemoteAddrField();
            }
        }

        protected boolean validatebgpPeerRemoteAddrField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemoteAddrField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerRemoteAddrFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerRemoteAddrFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerRemotePortField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerRemotePort.access", "read-only");
            this.bgpPeerRemotePortFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerRemotePortFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerRemotePortLabel"), 2);
            if (this.bgpPeerRemotePortFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.bgpPeerRemotePortFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerRemotePortFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerRemotePortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemotePortField);
            this.validatebgpPeerRemotePortField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerRemotePortField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemotePortField);
                jDMInput.setValue(object);
                this.validatebgpPeerRemotePortField();
            }
        }

        protected boolean validatebgpPeerRemotePortField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemotePortField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerRemotePortFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerRemotePortFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerRemoteAsField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerRemoteAs.access", "read-only");
            this.bgpPeerRemoteAsFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerRemoteAsFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerRemoteAsLabel"), 2);
            if (this.bgpPeerRemoteAsFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 65535);
                this.addRow(this.bgpPeerRemoteAsFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerRemoteAsFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerRemoteAsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemoteAsField);
            this.validatebgpPeerRemoteAsField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerRemoteAsField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemoteAsField);
                jDMInput.setValue(object);
                this.validatebgpPeerRemoteAsField();
            }
        }

        protected boolean validatebgpPeerRemoteAsField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerRemoteAsField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerRemoteAsFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerRemoteAsFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerLastErrorField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerLastError.access", "read-only");
            String string2 = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerLastError.length", "2");
            this.bgpPeerLastErrorFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerLastErrorFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerLastErrorLabel"), 2);
            if (this.bgpPeerLastErrorFieldWritable) {
                HexInput hexInput = new HexInput();
                hexInput.setMaxLength(Integer.parseInt(string2));
                this.addRow(this.bgpPeerLastErrorFieldLabel, (Component)hexInput);
                BgpPeerPanel.this.containsWritableField = true;
                return hexInput;
            }
            HexInputRO hexInputRO = new HexInputRO();
            this.addRow(this.bgpPeerLastErrorFieldLabel, (Component)hexInputRO);
            return hexInputRO;
        }

        protected Serializable getbgpPeerLastErrorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLastErrorField);
            this.validatebgpPeerLastErrorField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerLastErrorField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLastErrorField);
                jDMInput.setValue(object);
                this.validatebgpPeerLastErrorField();
            }
        }

        protected boolean validatebgpPeerLastErrorField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerLastErrorField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerLastErrorFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerLastErrorFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerFsmEstablishedTimeField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerFsmEstablishedTime.access", "read-only");
            this.bgpPeerFsmEstablishedTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerFsmEstablishedTimeFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerFsmEstablishedTimeLabel"), 2);
            if (this.bgpPeerFsmEstablishedTimeFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.bgpPeerFsmEstablishedTimeFieldLabel, (Component)longNumericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerFsmEstablishedTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerFsmEstablishedTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerFsmEstablishedTimeField);
            this.validatebgpPeerFsmEstablishedTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerFsmEstablishedTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerFsmEstablishedTimeField);
                jDMInput.setValue(object);
                this.validatebgpPeerFsmEstablishedTimeField();
            }
        }

        protected boolean validatebgpPeerFsmEstablishedTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerFsmEstablishedTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerFsmEstablishedTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerFsmEstablishedTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerConnectRetryIntervalField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerConnectRetryInterval.access", "read-write");
            this.bgpPeerConnectRetryIntervalFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerConnectRetryIntervalFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerConnectRetryIntervalLabel"), 2);
            if (this.bgpPeerConnectRetryIntervalFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 65535);
                this.addRow(this.bgpPeerConnectRetryIntervalFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerConnectRetryIntervalFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerConnectRetryIntervalField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerConnectRetryIntervalField);
            this.validatebgpPeerConnectRetryIntervalField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerConnectRetryIntervalField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerConnectRetryIntervalField);
                jDMInput.setValue(object);
                this.validatebgpPeerConnectRetryIntervalField();
            }
        }

        protected boolean validatebgpPeerConnectRetryIntervalField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerConnectRetryIntervalField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerConnectRetryIntervalFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerConnectRetryIntervalFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerHoldTimeField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerHoldTime.access", "read-only");
            this.bgpPeerHoldTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerHoldTimeFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerHoldTimeLabel"), 2);
            if (this.bgpPeerHoldTimeFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 3);
                this.addRow(this.bgpPeerHoldTimeFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerHoldTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerHoldTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerHoldTimeField);
            this.validatebgpPeerHoldTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerHoldTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerHoldTimeField);
                jDMInput.setValue(object);
                this.validatebgpPeerHoldTimeField();
            }
        }

        protected boolean validatebgpPeerHoldTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerHoldTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerHoldTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerHoldTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerKeepAliveField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerKeepAlive.access", "read-only");
            this.bgpPeerKeepAliveFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerKeepAliveFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerKeepAliveLabel"), 2);
            if (this.bgpPeerKeepAliveFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 1);
                this.addRow(this.bgpPeerKeepAliveFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerKeepAliveFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerKeepAliveField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerKeepAliveField);
            this.validatebgpPeerKeepAliveField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerKeepAliveField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerKeepAliveField);
                jDMInput.setValue(object);
                this.validatebgpPeerKeepAliveField();
            }
        }

        protected boolean validatebgpPeerKeepAliveField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerKeepAliveField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerKeepAliveFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerKeepAliveFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerHoldTimeConfiguredField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerHoldTimeConfigured.access", "read-write");
            this.bgpPeerHoldTimeConfiguredFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerHoldTimeConfiguredFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerHoldTimeConfiguredLabel"), 2);
            if (this.bgpPeerHoldTimeConfiguredFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 3);
                this.addRow(this.bgpPeerHoldTimeConfiguredFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerHoldTimeConfiguredFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerHoldTimeConfiguredField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerHoldTimeConfiguredField);
            this.validatebgpPeerHoldTimeConfiguredField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerHoldTimeConfiguredField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerHoldTimeConfiguredField);
                jDMInput.setValue(object);
                this.validatebgpPeerHoldTimeConfiguredField();
            }
        }

        protected boolean validatebgpPeerHoldTimeConfiguredField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerHoldTimeConfiguredField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerHoldTimeConfiguredFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerHoldTimeConfiguredFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerKeepAliveConfiguredField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerKeepAliveConfigured.access", "read-write");
            this.bgpPeerKeepAliveConfiguredFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerKeepAliveConfiguredFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerKeepAliveConfiguredLabel"), 2);
            if (this.bgpPeerKeepAliveConfiguredFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(0, 1);
                this.addRow(this.bgpPeerKeepAliveConfiguredFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerKeepAliveConfiguredFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerKeepAliveConfiguredField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerKeepAliveConfiguredField);
            this.validatebgpPeerKeepAliveConfiguredField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerKeepAliveConfiguredField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerKeepAliveConfiguredField);
                jDMInput.setValue(object);
                this.validatebgpPeerKeepAliveConfiguredField();
            }
        }

        protected boolean validatebgpPeerKeepAliveConfiguredField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerKeepAliveConfiguredField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerKeepAliveConfiguredFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerKeepAliveConfiguredFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerMinASOriginationIntervalField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerMinASOriginationInterval.access", "read-write");
            this.bgpPeerMinASOriginationIntervalFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerMinASOriginationIntervalFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerMinASOriginationIntervalLabel"), 2);
            if (this.bgpPeerMinASOriginationIntervalFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 65535);
                this.addRow(this.bgpPeerMinASOriginationIntervalFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerMinASOriginationIntervalFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerMinASOriginationIntervalField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerMinASOriginationIntervalField);
            this.validatebgpPeerMinASOriginationIntervalField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerMinASOriginationIntervalField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerMinASOriginationIntervalField);
                jDMInput.setValue(object);
                this.validatebgpPeerMinASOriginationIntervalField();
            }
        }

        protected boolean validatebgpPeerMinASOriginationIntervalField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerMinASOriginationIntervalField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerMinASOriginationIntervalFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerMinASOriginationIntervalFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerMinRouteAdvertisementIntervalField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerMinRouteAdvertisementInterval.access", "read-write");
            this.bgpPeerMinRouteAdvertisementIntervalFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerMinRouteAdvertisementIntervalFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerMinRouteAdvertisementIntervalLabel"), 2);
            if (this.bgpPeerMinRouteAdvertisementIntervalFieldWritable) {
                NumericInput numericInput = new NumericInput();
                numericInput.setMinMax(1, 65535);
                this.addRow(this.bgpPeerMinRouteAdvertisementIntervalFieldLabel, (Component)numericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return numericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerMinRouteAdvertisementIntervalFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerMinRouteAdvertisementIntervalField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerMinRouteAdvertisementIntervalField);
            this.validatebgpPeerMinRouteAdvertisementIntervalField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerMinRouteAdvertisementIntervalField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerMinRouteAdvertisementIntervalField);
                jDMInput.setValue(object);
                this.validatebgpPeerMinRouteAdvertisementIntervalField();
            }
        }

        protected boolean validatebgpPeerMinRouteAdvertisementIntervalField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerMinRouteAdvertisementIntervalField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerMinRouteAdvertisementIntervalFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerMinRouteAdvertisementIntervalFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        protected Component createbgpPeerInUpdateElapsedTimeField() {
            String string = BgpPeerPanel.this.getOverride("ibm.nways.bgp.model.Peer.Panel.BgpPeerInUpdateElapsedTime.access", "read-only");
            this.bgpPeerInUpdateElapsedTimeFieldWritable = string.equals("read-write") || string.equals("write-only");
            this.bgpPeerInUpdateElapsedTimeFieldLabel = new Label(BgpPeerPanel.getNLSString("bgpPeerInUpdateElapsedTimeLabel"), 2);
            if (this.bgpPeerInUpdateElapsedTimeFieldWritable) {
                LongNumericInput longNumericInput = new LongNumericInput();
                this.addRow(this.bgpPeerInUpdateElapsedTimeFieldLabel, (Component)longNumericInput);
                BgpPeerPanel.this.containsWritableField = true;
                return longNumericInput;
            }
            StringInputRO stringInputRO = new StringInputRO();
            this.addRow(this.bgpPeerInUpdateElapsedTimeFieldLabel, (Component)stringInputRO);
            return stringInputRO;
        }

        protected Serializable getbgpPeerInUpdateElapsedTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerInUpdateElapsedTimeField);
            this.validatebgpPeerInUpdateElapsedTimeField();
            Serializable serializable = (Serializable)jDMInput.getValue();
            return serializable;
        }

        protected void setbgpPeerInUpdateElapsedTimeField(Object object) {
            if (object != null) {
                JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerInUpdateElapsedTimeField);
                jDMInput.setValue(object);
                this.validatebgpPeerInUpdateElapsedTimeField();
            }
        }

        protected boolean validatebgpPeerInUpdateElapsedTimeField() {
            JDMInput jDMInput = (JDMInput)((Object)this.bgpPeerInUpdateElapsedTimeField);
            if (!jDMInput.isValidValue() && !jDMInput.ignoreValue()) {
                this.bgpPeerInUpdateElapsedTimeFieldLabel.setForeground(Color.yellow);
            } else {
                this.bgpPeerInUpdateElapsedTimeFieldLabel.setForeground(JmaColors.textText);
            }
            return jDMInput.isValidValue();
        }

        public void layoutSection() {
            this.bgpPeerIdentifierField = this.createbgpPeerIdentifierField();
            this.bgpPeerStateField = this.createbgpPeerStateField();
            this.bgpPeerAdminStatusField = this.createbgpPeerAdminStatusField();
            this.bgpPeerNegotiatedVersionField = this.createbgpPeerNegotiatedVersionField();
            this.bgpPeerLocalAddrField = this.createbgpPeerLocalAddrField();
            this.bgpPeerLocalPortField = this.createbgpPeerLocalPortField();
            this.bgpPeerRemoteAddrField = this.createbgpPeerRemoteAddrField();
            this.bgpPeerRemotePortField = this.createbgpPeerRemotePortField();
            this.bgpPeerRemoteAsField = this.createbgpPeerRemoteAsField();
            this.bgpPeerLastErrorField = this.createbgpPeerLastErrorField();
            this.bgpPeerFsmEstablishedTimeField = this.createbgpPeerFsmEstablishedTimeField();
            this.bgpPeerConnectRetryIntervalField = this.createbgpPeerConnectRetryIntervalField();
            this.bgpPeerHoldTimeField = this.createbgpPeerHoldTimeField();
            this.bgpPeerKeepAliveField = this.createbgpPeerKeepAliveField();
            this.bgpPeerHoldTimeConfiguredField = this.createbgpPeerHoldTimeConfiguredField();
            this.bgpPeerKeepAliveConfiguredField = this.createbgpPeerKeepAliveConfiguredField();
            this.bgpPeerMinASOriginationIntervalField = this.createbgpPeerMinASOriginationIntervalField();
            this.bgpPeerMinRouteAdvertisementIntervalField = this.createbgpPeerMinRouteAdvertisementIntervalField();
            this.bgpPeerInUpdateElapsedTimeField = this.createbgpPeerInUpdateElapsedTimeField();
        }

        public void apply() {
            if (this.validateSection()) {
                if (!((JDMInput)((Object)this.bgpPeerIdentifierField)).ignoreValue() && this.bgpPeerIdentifierFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerIdentifier", this.getbgpPeerIdentifierField());
                }
                if (!((JDMInput)((Object)this.bgpPeerStateField)).ignoreValue() && this.bgpPeerStateFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerState", this.getbgpPeerStateField());
                }
                if (!((JDMInput)((Object)this.bgpPeerAdminStatusField)).ignoreValue() && this.bgpPeerAdminStatusFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerAdminStatus", this.getbgpPeerAdminStatusField());
                }
                if (!((JDMInput)((Object)this.bgpPeerNegotiatedVersionField)).ignoreValue() && this.bgpPeerNegotiatedVersionFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerNegotiatedVersion", this.getbgpPeerNegotiatedVersionField());
                }
                if (!((JDMInput)((Object)this.bgpPeerLocalAddrField)).ignoreValue() && this.bgpPeerLocalAddrFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerLocalAddr", this.getbgpPeerLocalAddrField());
                }
                if (!((JDMInput)((Object)this.bgpPeerLocalPortField)).ignoreValue() && this.bgpPeerLocalPortFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerLocalPort", this.getbgpPeerLocalPortField());
                }
                if (!((JDMInput)((Object)this.bgpPeerRemoteAddrField)).ignoreValue() && this.bgpPeerRemoteAddrFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerRemoteAddr", this.getbgpPeerRemoteAddrField());
                }
                if (!((JDMInput)((Object)this.bgpPeerRemotePortField)).ignoreValue() && this.bgpPeerRemotePortFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerRemotePort", this.getbgpPeerRemotePortField());
                }
                if (!((JDMInput)((Object)this.bgpPeerRemoteAsField)).ignoreValue() && this.bgpPeerRemoteAsFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerRemoteAs", this.getbgpPeerRemoteAsField());
                }
                if (!((JDMInput)((Object)this.bgpPeerLastErrorField)).ignoreValue() && this.bgpPeerLastErrorFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerLastError", this.getbgpPeerLastErrorField());
                }
                if (!((JDMInput)((Object)this.bgpPeerFsmEstablishedTimeField)).ignoreValue() && this.bgpPeerFsmEstablishedTimeFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerFsmEstablishedTime", this.getbgpPeerFsmEstablishedTimeField());
                }
                if (!((JDMInput)((Object)this.bgpPeerConnectRetryIntervalField)).ignoreValue() && this.bgpPeerConnectRetryIntervalFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerConnectRetryInterval", this.getbgpPeerConnectRetryIntervalField());
                }
                if (!((JDMInput)((Object)this.bgpPeerHoldTimeField)).ignoreValue() && this.bgpPeerHoldTimeFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerHoldTime", this.getbgpPeerHoldTimeField());
                }
                if (!((JDMInput)((Object)this.bgpPeerKeepAliveField)).ignoreValue() && this.bgpPeerKeepAliveFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerKeepAlive", this.getbgpPeerKeepAliveField());
                }
                if (!((JDMInput)((Object)this.bgpPeerHoldTimeConfiguredField)).ignoreValue() && this.bgpPeerHoldTimeConfiguredFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerHoldTimeConfigured", this.getbgpPeerHoldTimeConfiguredField());
                }
                if (!((JDMInput)((Object)this.bgpPeerKeepAliveConfiguredField)).ignoreValue() && this.bgpPeerKeepAliveConfiguredFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerKeepAliveConfigured", this.getbgpPeerKeepAliveConfiguredField());
                }
                if (!((JDMInput)((Object)this.bgpPeerMinASOriginationIntervalField)).ignoreValue() && this.bgpPeerMinASOriginationIntervalFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerMinASOriginationInterval", this.getbgpPeerMinASOriginationIntervalField());
                }
                if (!((JDMInput)((Object)this.bgpPeerMinRouteAdvertisementIntervalField)).ignoreValue() && this.bgpPeerMinRouteAdvertisementIntervalFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerMinRouteAdvertisementInterval", this.getbgpPeerMinRouteAdvertisementIntervalField());
                }
                if (!((JDMInput)((Object)this.bgpPeerInUpdateElapsedTimeField)).ignoreValue() && this.bgpPeerInUpdateElapsedTimeFieldWritable) {
                    BgpPeerPanel.this.PanelInfo.add("Panel.BgpPeerInUpdateElapsedTime", this.getbgpPeerInUpdateElapsedTimeField());
                    return;
                }
            } else {
                BgpPeerPanel.this.errorsFound = true;
            }
        }

        public void reset() {
            BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("accessDataMsg"));
            try {
                this.setbgpPeerIdentifierField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerIdentifier", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerStateField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerState", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerAdminStatusField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerAdminStatus", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerNegotiatedVersionField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerNegotiatedVersion", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerLocalAddrField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerLocalAddr", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerLocalPortField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerLocalPort", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerRemoteAddrField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerRemoteAddr", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerRemotePortField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerRemotePort", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerRemoteAsField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerRemoteAs", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerLastErrorField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerLastError", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerFsmEstablishedTimeField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerFsmEstablishedTime", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerConnectRetryIntervalField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerConnectRetryInterval", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerHoldTimeField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerHoldTime", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerKeepAliveField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerKeepAlive", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerHoldTimeConfiguredField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerHoldTimeConfigured", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerKeepAliveConfiguredField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerKeepAliveConfigured", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerMinASOriginationIntervalField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerMinASOriginationInterval", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerMinRouteAdvertisementIntervalField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerMinRouteAdvertisementInterval", BgpPeerPanel.this.BgpPeerTableIndex));
                this.setbgpPeerInUpdateElapsedTimeField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerInUpdateElapsedTime", BgpPeerPanel.this.BgpPeerTableIndex));
            }
            catch (NullPointerException nullPointerException) {}
            BgpPeerPanel.this.errorsFound = !this.validateSection();
            this.doLayout();
        }

        protected void rowChange() {
            this.setbgpPeerIdentifierField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerIdentifier", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerStateField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerState", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerAdminStatusField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerAdminStatus", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerNegotiatedVersionField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerNegotiatedVersion", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerLocalAddrField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerLocalAddr", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerLocalPortField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerLocalPort", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerRemoteAddrField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerRemoteAddr", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerRemotePortField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerRemotePort", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerRemoteAsField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerRemoteAs", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerLastErrorField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerLastError", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerFsmEstablishedTimeField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerFsmEstablishedTime", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerConnectRetryIntervalField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerConnectRetryInterval", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerHoldTimeField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerHoldTime", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerKeepAliveField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerKeepAlive", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerHoldTimeConfiguredField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerHoldTimeConfigured", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerKeepAliveConfiguredField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerKeepAliveConfigured", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerMinASOriginationIntervalField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerMinASOriginationInterval", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerMinRouteAdvertisementIntervalField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerMinRouteAdvertisementInterval", BgpPeerPanel.this.BgpPeerTableIndex));
            this.setbgpPeerInUpdateElapsedTimeField(BgpPeerPanel.this.BgpPeerTableData.getValueAt("Panel.BgpPeerInUpdateElapsedTime", BgpPeerPanel.this.BgpPeerTableIndex));
            this.doLayout();
        }

        public boolean validateSection() {
            if (!((JDMInput)((Object)this.bgpPeerMinRouteAdvertisementIntervalField)).ignoreValue() && !this.validatebgpPeerMinRouteAdvertisementIntervalField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.bgpPeerKeepAliveConfiguredField)).ignoreValue() && !this.validatebgpPeerKeepAliveConfiguredField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.bgpPeerConnectRetryIntervalField)).ignoreValue() && !this.validatebgpPeerConnectRetryIntervalField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.bgpPeerHoldTimeConfiguredField)).ignoreValue() && !this.validatebgpPeerHoldTimeConfiguredField()) {
                return false;
            }
            if (!((JDMInput)((Object)this.bgpPeerAdminStatusField)).ignoreValue() && !this.validatebgpPeerAdminStatusField()) {
                return false;
            }
            return ((JDMInput)((Object)this.bgpPeerMinASOriginationIntervalField)).ignoreValue() || this.validatebgpPeerMinASOriginationIntervalField();
        }
    }

    public class BgpPeerTable
    extends Table {
        public ModelInfo setRow() {
            try {
                BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("startSendMsg"));
                BgpPeerPanel.this.PanelInfo = BgpPeerPanel.this.Peer_model.setInfo("Panel", BgpPeerPanel.this.PanelInfo);
                BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("endSendMsg"));
                if (BgpPeerPanel.this.PanelInfo != null) {
                    Enumeration enumeration = BgpPeerPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = BgpPeerPanel.this.PanelInfo.get(string);
                        BgpPeerPanel.this.BgpPeerTableInfo.add(string, serializable);
                    }
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return BgpPeerPanel.this.BgpPeerTableInfo;
        }

        public ModelInfo getRow(ModelInfo modelInfo) {
            try {
                while (true) {
                    BgpPeerPanel.this.BgpPeerTableInfo = null;
                    BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("startRow"));
                    BgpPeerPanel.this.PanelInfo = BgpPeerPanel.this.Peer_model.getNextInfo("Panel", "default", modelInfo);
                    BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("endRow"));
                    if (BgpPeerPanel.this.PanelInfo != null) {
                        BgpPeerPanel.this.BgpPeerTableInfo = new ModelInfo();
                        if (BgpPeerPanel.this.PanelInfo.isBeingMonitored()) {
                            BgpPeerPanel.this.BgpPeerTableInfo.flagAsMonitored();
                        }
                        Enumeration enumeration = BgpPeerPanel.this.PanelInfo.getItemIds();
                        while (enumeration.hasMoreElements()) {
                            String string = (String)enumeration.nextElement();
                            Serializable serializable = BgpPeerPanel.this.PanelInfo.get(string);
                            BgpPeerPanel.this.BgpPeerTableInfo.add(string, serializable);
                        }
                    }
                    if (BgpPeerPanel.this.BgpPeerTableInfo != null && !this.validRow(BgpPeerPanel.this.BgpPeerTableInfo)) {
                        modelInfo = BgpPeerPanel.this.BgpPeerTableInfo;
                        continue;
                    }
                    break;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return BgpPeerPanel.this.BgpPeerTableInfo;
        }

        public ModelInfo getSpecificRow(ModelInfo modelInfo) {
            BgpPeerPanel.this.BgpPeerTableInfo = null;
            try {
                BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("startRow"));
                BgpPeerPanel.this.PanelInfo = BgpPeerPanel.this.Peer_model.getInfo("Panel", "default", modelInfo);
                BgpPeerPanel.this.displayMsg(BgpPeerPanel.getNLSString("endRow"));
                if (BgpPeerPanel.this.PanelInfo != null) {
                    BgpPeerPanel.this.BgpPeerTableInfo = new ModelInfo();
                    if (BgpPeerPanel.this.PanelInfo.isBeingMonitored()) {
                        BgpPeerPanel.this.BgpPeerTableInfo.flagAsMonitored();
                    }
                    Enumeration enumeration = BgpPeerPanel.this.PanelInfo.getItemIds();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        Serializable serializable = BgpPeerPanel.this.PanelInfo.get(string);
                        BgpPeerPanel.this.BgpPeerTableInfo.add(string, serializable);
                    }
                }
                if (BgpPeerPanel.this.BgpPeerTableInfo != null && !this.validRow(BgpPeerPanel.this.BgpPeerTableInfo)) {
                    BgpPeerPanel.this.BgpPeerTableInfo = this.getRow(BgpPeerPanel.this.BgpPeerTableInfo);
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
            return BgpPeerPanel.this.BgpPeerTableInfo;
        }

        public boolean validRow(ModelInfo modelInfo) {
            return true;
        }

        public void setMonitoring(ModelInfo[] modelInfoArray, boolean bl) {
            try {
                if (BgpPeerPanel.this.BgpPeerTableStatus != null) {
                    if (modelInfoArray != null) {
                        if (bl) {
                            BgpPeerPanel.this.BgpPeerTableStatus.monitor(modelInfoArray);
                            return;
                        }
                        BgpPeerPanel.this.BgpPeerTableStatus.doNotMonitor(modelInfoArray);
                        return;
                    }
                    if (bl) {
                        BgpPeerPanel.this.BgpPeerTableStatus.setMaxRows(Integer.MAX_VALUE);
                        return;
                    }
                    BgpPeerPanel.this.BgpPeerTableStatus.setMaxRows(0);
                    return;
                }
            }
            catch (RemoteException remoteException) {
                System.out.println(remoteException);
                remoteException.printStackTrace();
            }
        }

        public String translateEnum(String string, int n) {
            String string2 = String.valueOf(n);
            try {
                if (string.equals("Panel.BgpPeerState")) {
                    string2 = enumStrings.getString(PeerModel.Panel.BgpPeerStateEnum.numericToSymbolic(n));
                }
            }
            catch (MissingResourceException missingResourceException) {}
            return string2;
        }

        public BgpPeerTable() {
            BgpPeerPanel.this = BgpPeerPanel.this;
        }
    }
}

